#-----------------------------------------------------
# module DataManager
# ゲーム内で使用されるデータを定めたり
# ゲームデータのセーブ、ロードを行うモジュール。
#-----------------------------------------------------
module DataManager
  # データの初期化
  def self.init
    Encoding.default_external = 'utf-8'
    self.remove_temp
    create_game_objects
    $audio = Audio_Data.new
    images_init
    $log = 0
  end
  # 一時ファイルの生成
  def self.create_temp
    FileUtils.touch("save/temp/item")
    FileUtils.touch("save/temp/plugin")
    FileUtils.touch("save/temp/skill")
    FileUtils.touch("save/temp/state")
    FileUtils.touch("save/temp/debuff")
    FileUtils.touch("save/temp/mission")
  end
  # 一時ファイルの削除
  def self.remove_temp
    FileUtils.rm_rf("save/temp") if FileTest.exist?("save/temp")
  end
  # 常駐させる画像データをロード
  def self.images_init
    $image_meter = Image.load($game_directory + '/data/img/menu/spectrum.png')
    $image_auto = Image.load($game_directory + '/data/img/menu/auto.png')
    $image_mapname = Image.load($game_directory + '/data/img/menu/mapname.png')
  end
  # 各種ゲームオブジェクトの作成
  def self.create_game_objects
    $system             = Game_System.new
    $player             = Game_Player.new
    $game_switches  = []
    $game_variables = []
    $game_self_switches = []
  end
  # ニューゲーム
  def self.setup_newgame
    self.create_temp
    create_game_objects
    $player.x = $system.init_pos[:x]
    $player.y = $system.init_pos[:y]
    $player.dir = 1
    $system.reset_timelap
  end
  # セーブファイルの存在判定
  def self.save_file_exists?
    !Dir.glob('save/Save*').empty?
  end
  # セーブファイルの最大数
  def self.savefile_max
    return 50
  end
  # セーブファイルのディレクトリ名の作成
  def self.make_directoryname(index)
    sprintf("save/Save%02d", index + 1)
  end
  # ファイル名の作成
  def self.make_filename(index)
    make_directoryname(index) + "/object"
  end
  # セーブの実行
  def self.save_game(index)
    begin
      p "save_game"
      save_game_without_rescue(index)
    rescue
      p "save_game false"
      delete_save_file(index)
      false
    end
  end
  # ロードの実行
  def self.load_game(index)
    load_game_without_rescue(index) rescue false
  end
  # セーブヘッダのロード
  def self.load_header(index)
    load_header_without_rescue(index) rescue nil
  end
  # セーブの実行
  def self.save_game_without_rescue(index)
  	p make_directoryname(index)
    FileUtils.mkdir_p(make_directoryname(index)) unless FileTest.exist?(make_directoryname(index))
    p "mkdir ok"
    File.open(make_filename(index), "wb") do |file|
      p "fileopen ok"
      $system.on_before_save
      Marshal.dump(make_save_header, file)
      p "headerdump ok"
      Marshal.dump(make_save_contents, file)
      p "contentsdump ok"
    end
    save_items(index)
    p "save_items ok"
    FileUtils.touch("data/bin/system/last_savefile") unless FileTest.exist?("data/bin/system/last_savefile")
    p "last_savefile touch ok"
    File.open("data/bin/system/last_savefile", "wb") do |file|
      p "last_savefile open ok"
      Marshal.dump(index, file)
      p "last_savefile dump ok"
    end
    return true
  end
  # ロードの実行
  def self.load_game_without_rescue(index)
    File.open(make_filename(index), "rb") do |file|
      Marshal.load(file)
      extract_save_contents(Marshal.load(file))
    end
    load_items(index)
    FileUtils.touch("data/bin/system/last_savefile") unless FileTest.exist?("data/bin/system/last_savefile")
    File.open("data/bin/system/last_savefile", "wb") do |file|
      Marshal.dump(index, file)
    end
    return true
  end
  # 所持しているアイテムオブジェクトファイルのセーブ
  def self.save_items(index)
    if FileTest.exist?("save/temp/item")
      FileUtils.cp("save/temp/item", make_directoryname(index) + "/item")
    end
    if FileTest.exist?("save/temp/plugin")
      FileUtils.cp("save/temp/plugin", make_directoryname(index) + "/plugin")
    end
    if FileTest.exist?("save/temp/skill")
      FileUtils.cp("save/temp/skill", make_directoryname(index) + "/skill")
    end
    if FileTest.exist?("save/temp/state")
      FileUtils.cp("save/temp/state", make_directoryname(index) + "/state")
    end
    if FileTest.exist?("save/temp/debuff")
      FileUtils.cp("save/temp/debuff", make_directoryname(index) + "/debuff")
    end
    if FileTest.exist?("save/temp/mission")
      FileUtils.cp("save/temp/mission", make_directoryname(index) + "/mission")
    end
  end
  # 所持しているアイテムオブジェクトファイルのロード
  def self.load_items(index)
    if FileTest.exist?(make_directoryname(index) + "/item")
      FileUtils.cp(make_directoryname(index) + "/item", "save/temp/item")
    else
      FileUtils.touch("save/temp/item")
    end
    if FileTest.exist?(make_directoryname(index) + "/plugin")
      FileUtils.cp(make_directoryname(index) + "/plugin", "save/temp/plugin")
    else
      FileUtils.touch("save/temp/plugin")
    end
    if FileTest.exist?(make_directoryname(index) + "/skill")
      FileUtils.cp(make_directoryname(index) + "/skill", "save/temp/skill")
    else
      FileUtils.touch("save/temp/skill")
    end
    if FileTest.exist?(make_directoryname(index) + "/state")
      FileUtils.cp(make_directoryname(index) + "/state", "save/temp/state")
    else
      FileUtils.touch("save/temp/state")
    end
    if FileTest.exist?(make_directoryname(index) + "/debuff")
      FileUtils.cp(make_directoryname(index) + "/debuff", "save/temp/debuff")
    else
      FileUtils.touch("save/temp/debuff")
    end
    if FileTest.exist?(make_directoryname(index) + "/mission")
      FileUtils.cp(make_directoryname(index) + "/mission", "save/temp/mission")
    else
      FileUtils.touch("save/temp/mission")
    end
  end
  # セーブヘッダのロード
  def self.load_header_without_rescue(index)
    File.open(make_filename(index), "rb") do |file|
      return Marshal.load(file)
    end
    return nil
  end
  # セーブファイルの削除
  def self.delete_save_file(index)
    File.delete(make_filename(index)) rescue nil
  end
  # セーブヘッダの作成
  def self.make_save_header
    header = {}
    header[:part] = 1
    # header[:level] = $player.level
    header[:place] = $player.place
    header[:playtime_s] = $system.playtime_s
    header
  end
  # セーブ内容の作成
  def self.make_save_contents
    contents = {}
    contents[:system]        = $system
    contents[:player]        = $player
    contents[:switches]      = $game_switches
    contents[:variables]     = $game_variables
    contents[:self_switches] = $game_self_switches
    contents
  end
  # セーブ内容の展開
  def self.extract_save_contents(contents)
    $system             = contents[:system]
    $player             = contents[:player]
    $game_switches      = contents[:switches]
    $game_variables     = contents[:variables]
    $game_self_switches = contents[:self_switches]
  end
  # 最後にアクセスしたファイルのインデックスを取得
  def self.last_savefile_index
    return FileTest.exist?("data/bin/system/last_savefile") ? Marshal.load(open("data/bin/system/last_savefile")) : 0
  end
end
